<?php

namespace FiloBlu\StockaFix\Controller\Adminhtml\Download;

/**
 * Class Index
 * @package FiloBlu\StockaFix\Controller\Adminhtml\Report
 */
class Index extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;
    /**
     * @var \FiloBlu\StockaFix\Helper\ReportHelper
     */
    protected $reportHelper;
    /**
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    protected $dir;

    /**
     * Constructor
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper,
        \Magento\Framework\Filesystem\DirectoryList $dir
    )
    {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->reportHelper = $reportHelper;
        $this->dir = $dir;
    }

    /**
     * Execute view action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        try{
            $report = $this->reportHelper->getReportFromRequest($this->getRequest(),'id');
            $fileName = $this->getRequest()->getParam('file');
            $filePath = trim($report->getData('file_path'),'/');
            $file = $this->dir->getRoot() . DIRECTORY_SEPARATOR . $filePath . DIRECTORY_SEPARATOR . $fileName;

            if (file_exists($file)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="'.basename($file).'"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($file));
                readfile($file);
                exit;
            }
            $this->messageManager->addErrorMessage(__('File does not exist'));
            $resultRedirect = $this->resultRedirectFactory->create();
            return $resultRedirect->setPath($this->getRedirectUrl(), ['_current' => true]);
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__($e->getMessage()));
            $resultRedirect = $this->resultRedirectFactory->create();
            return $resultRedirect->setPath($this->getRedirectUrl(), ['_current' => true]);
        }
    }

    /**
     * @return string
     */
    public function getRedirectUrl() {
        $id = $this->getRequest()->getParam('id');
        $record = $this->getRequest()->getParam('record');
        if(!empty($record)) {
            return 'filoblu_stockafix/reportoutput/edit/id/'.$id.'/record/'.$record;
        }
        return 'filoblu_stockafix/reportoutput/index/id/'.$id;
    }
}
