<?php

namespace FiloBlu\ShipmentEmailTrack\Rewrite\Magento\Shipping\Block\Adminhtml\Order\Tracking;
use FiloBlu\ShipmentEmailTrack\Helper\Data;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Sales\Model\Order\Shipment\Track;
use Magento\Shipping\Model\CarrierFactory;
use Magento\Shipping\Model\Config;

/**
 * Class View
 * @package FiloBlu\ShipmentEmailTrack\Rewrite\Magento\Shipping\Block\Adminhtml\Order\Tracking
 */
class View extends \Magento\Shipping\Block\Adminhtml\Order\Tracking\View
{
    /**
     * @var Data
     */
    protected $helperData;

    /**
     * @param Context $context
     * @param Config $shippingConfig
     * @param Registry $registry
     * @param CarrierFactory $carrierFactory
     * @param Data $helperData
     * @param array $data
     */
    public function __construct(
        Context $context,
        Config $shippingConfig,
        Registry $registry,
        CarrierFactory $carrierFactory,
        Data $helperData,
        array $data = []
    )
    {
        parent::__construct($context, $shippingConfig, $registry, $carrierFactory, $data);
        $this->helperData = $helperData;
    }

    /**
     * @param Track $track
     * @return mixed|string
     */
    public function generateTrackingLink(Track $track)
    {
        return $this->helperData->getTrackingNumberLink($track);
    }
}