<?php

declare(strict_types=1);

namespace FiloBlu\ShipmentEmailTrack\Plugin;

use FiloBlu\ShipmentEmailTrack\Helper\Data;
use Magento\Sales\Api\Data\ShipmentInterface;
use Magento\Sales\Api\Data\ShipmentSearchResultInterface;
use Magento\Sales\Api\ShipmentRepositoryInterface;

/**
 *
 */
class AddTrackingUrl {
    /**
     * @var \FiloBlu\ShipmentEmailTrack\Helper\Data
     */
    private $data;

    /**
     * @param \FiloBlu\ShipmentEmailTrack\Helper\Data $data
     */
    public function __construct(Data $data)
    {
        $this->data = $data;
    }

    /**
     * @param \Magento\Sales\Api\ShipmentRepositoryInterface $subject
     * @param \Magento\Sales\Api\Data\ShipmentSearchResultInterface $result
     * @return \Magento\Sales\Api\Data\ShipmentSearchResultInterface
     *@see \Magento\Sales\Api\ShipmentRepositoryInterface::getList
     */
    public function afterGetList(ShipmentRepositoryInterface $subject, ShipmentSearchResultInterface $result): ShipmentSearchResultInterface
    {
        foreach ($result->getItems() as $item){
            $this->afterGet($subject, $item);
        }
        return $result;
    }

    /**
     * @param \Magento\Sales\Api\ShipmentRepositoryInterface $subject
     * @param \Magento\Sales\Api\Data\ShipmentInterface $result
     * @return \Magento\Sales\Api\Data\ShipmentInterface
     * @see \Magento\Sales\Api\ShipmentRepositoryInterface::get
     */
    public function afterGet(ShipmentRepositoryInterface $subject, ShipmentInterface $result): ShipmentInterface
    {
        foreach($result->getTracks() as $track){
            if(!$track->getExtensionAttributes()){
                continue;
            }
            $track->getExtensionAttributes()->setFilobluTrackingUrl($this->data->getTrackingNumberLink($track));
        }

        return $result;
    }
}