<?php
declare(strict_types=1);

namespace FiloBlu\ShipmentEmailTrack\Helper\Shipping;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Sales\Model\AbstractModel;
use Magento\Store\Model\ScopeInterface;

/**
 * @Class Data
 * @Package \FiloBlu\ShipmentEmailTrack\Helper\Shipping
 */
class Data extends \Magento\Shipping\Helper\Data implements ArgumentInterface
{
    /**
     * Shipping tracking popup URL getter
     *
     * @param AbstractModel $model
     * @return string
     */
    public function getTrackingPopupUrlBySalesModel($model)
    {
        if($this->scopeConfig->isSetFlag('web/url/redirect_to_base', ScopeInterface::SCOPE_STORE)) {
            return parent::getTrackingPopupUrlBySalesModel($model);
        }

        return $this->replaceDomain(parent::getTrackingPopupUrlBySalesModel($model));
    }

    /**
     * @param $url
     * @return string
     */
    public function replaceDomain($url)
    {
        return str_replace($this->getHostname($url), $this->getAdminDomain(), $url);
    }

    /**
     * @param $url
     * @return string|false
     */
    public function getHostname($url)
    {
        return parse_url($url, PHP_URL_HOST);
    }

    /**
     * @return false|string
     */
    public function getAdminDomain()
    {
        return $this->getHostname($this->_urlBuilder->setScope(0)->getBaseUrl());
    }
}
