<?php

namespace FiloBlu\ShipmentEmailTrack\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Sales\Api\Data\ShipmentTrackInterface;
use Magento\Sales\Model\Order\Shipment\Track;
use Magento\Store\Model\ScopeInterface;

/**
 * Class Data
 * @package FiloBlu\ShipmentEmailTrack\Helper
 */
class Data extends AbstractHelper
{
    /**
     * @param Track|\Magento\Sales\Api\Data\ShipmentTrackInterface $carrierItem
     * @return string|string[]
     */
    public function getTrackingNumberLink(ShipmentTrackInterface $carrierItem)
    {
        $carriersArray = unserialize($this->getConfig('carrier_setting/carriers'));

        if (!$carriersArray || count($carriersArray) == 0) {
            return '#';
        }

        foreach ($carriersArray as $carrier) {
            if (!$this->matchesCarrier($carrierItem, $carrier)) {
                continue;
            }
            return str_replace('##TRACKCODE##', $carrierItem->getNumber(), $carrier['base_url']);
        }

        return '#';
    }

    /**
     * @param $config_path
     * @param string $section
     * @return mixed
     */
    public function getConfig($config_path, $section = 'filoblu_shipmenteemailtrack_section')
    {
        return $this->scopeConfig->getValue("{$section}/{$config_path}", ScopeInterface::SCOPE_STORE);
    }

    /**
     * @param Track $track
     * @param $carrier
     * @return bool
     */
    public function matchesCarrier(Track $track, $carrier)
    {
        if (!isset($carrier['carrier_code'], $carrier['carrier_title'])) {
            return false;
        }

        $code = strtolower($carrier['carrier_code']);
        $title = strtolower($carrier['carrier_title']);

        $codeTrack = strtolower($track['carrier_code']);
        $titleTrack = strtolower($track['title']);

        if ($code === 'custom' && $title === $titleTrack) {
            return true;
        }

        if ($codeTrack !== 'custom' && $code === $codeTrack) {
            return true;
        }

        if ($codeTrack === 'custom' && $title === '*') {
            return true;
        }

        if ($codeTrack === '*' && $title === '*') {
            return true;
        }

        return false;
    }
}
