<?php

namespace FiloBlu\ShipmentEmailTrack\Block\Adminhtml\System\Config\Form\Field;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\DataObject;

/**
 * Class FieldsMapping
 * @package FiloBlu\ShipmentEmailTrack\Block\Adminhtml\System\Config\Form\Field
 */
class FieldsMapping extends AbstractFieldArray
{

    protected $_arrayRowsCache;

    /**
     * @var Factory
     */
    protected $_elementFactory;

    /**
     * @param Context $context
     * @param Factory $elementFactory
     * @param array $data
     */
    public function __construct(
        Context $context,
        Factory $elementFactory,
        array $data = []
    )
    {
        $this->_elementFactory = $elementFactory;
        parent::__construct($context, $data);
    }

    public function getArrayRows()
    {
        if (null !== $this->_arrayRowsCache) {
            return $this->_arrayRowsCache;
        }
        $result = [];
        /** @var AbstractElement */
        $element = $this->getElement();

        if ($element->getValue() && !is_array($element->getValue())) {
            $element->setValue(unserialize($element->getValue()));
        }

        $columnSetted = array_keys($this->getColumns());
        if ($element->getValue() && is_array($element->getValue())) {
            foreach ($element->getValue() as $rowId => $row) {

                /*
                 * Fix for unserialize of the values
                 * Check if other columns was created
                 */
                if (count($row) < count($columnSetted)) {
                    $rowColumn = array_keys($row);

                    // If new columns was created, I add the new column with empty value
                    foreach ($columnSetted as $col) {
                        if (!in_array($col, $rowColumn, false)) {
                            $row[$col] = '';
                        }
                    }
                }

                $rowColumnValues = [];
                foreach ($row as $key => $value) {
                    $row[$key] = $value;
                    $rowColumnValues[$this->_getCellInputElementId($rowId, $key)] = $row[$key];
                }

                $row['_id'] = $rowId;
                $row['column_values'] = $rowColumnValues;
                $result[$rowId] = new DataObject($row);
                $this->_prepareArrayRow($result[$rowId]);
            }
        }
        $this->_arrayRowsCache = $result;
        return $this->_arrayRowsCache;
    }

    protected function _construct()
    {
        $this->addColumn('carrier_code', ['label' => __('Carrier Code')]);
        $this->addColumn('carrier_title', ['label' => __('Carrier Title')]);
        $this->addColumn('base_url', ['label' => __('URL')]);
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
        parent::_construct();
    }
}
