define([
    'jquery',
    'knockout',
    'Magento_PageBuilder/js/events',
    'underscore',
    'Magento_PageBuilder/js/content-type/preview-collection',
    'Magento_PageBuilder/js/content-type-factory',
    'Magento_PageBuilder/js/config',
    'Magento_PageBuilder/js/content-type-menu/hide-show-option'
], function ($, ko, events, underscore, PreviewCollection, createContentType, pageBuilderConfig, _hideShowOption) {
    'use strict';

    /**
     * Preview Constructor
     *
     * @param parent
     * @param config
     * @param stageId
     * @constructor
     */
    function Preview(parent, config, stageId) {
        var self = this;

        PreviewCollection.call(this, parent, config, stageId);

        events.on("filoblu_countdown:dropAfter", function (args) {
            if (args.id === self.contentType.id && self.contentType.children().length === 0) {
                // Once the grid is ready, let's add in our children
                self.populateContainerGroup();
            }
        });
    }
    Preview.prototype = Object.create(PreviewCollection.prototype);

    /**
     * Populate the custom container group with 3 children
     */
    Preview.prototype.populateContainerGroup = function () {
        var self = this;

        createContentType(
            pageBuilderConfig.getContentTypeConfig("filoblu_countdown_before"),
            self.contentType,
            self.contentType.id
        ).then(function (containerBefore) {
            self.contentType.addChild(containerBefore);
        });

        createContentType(
            pageBuilderConfig.getContentTypeConfig("filoblu_countdown_after"),
            self.contentType,
            self.contentType.id
        ).then(function (containerAfter) {
            self.contentType.addChild(containerAfter);
        });
    };

    /**
     * Mark as not a standard container
     *
     * @returns {boolean}
     */
    Preview.prototype.isContainer = function () {
        return true;
    };

    Preview.prototype.retrieveOptions = function retrieveOptions() {
        var options = PreviewCollection.prototype.retrieveOptions.call(this);

        options.hideShow = new _hideShowOption({
            preview: this,
            icon: _hideShowOption.showIcon,
            title: _hideShowOption.showText,
            action: this.onOptionVisibilityToggle,
            classes: ["hide-show-content-type"],
            sort: 40
        });

        return options;
    };

    return Preview;
});
