<?php

namespace FiloBlu\Refilo\Model\Redirects\Interfaces;

use Magento\Framework\DataObject\IdentityInterface;

interface RedirectInterface extends IdentityInterface, RepositoryItem
{
    /** @var string */
    const ID = 'id';

    /** @var string */
    const HOST = 'host';

    /** @var string */
    const REQUEST_URL = 'request_url';

    /** @var string */
    const TARGET_URL = 'target_url';

    /** @var string */
    const REDIRECT_CODE = 'redirect_code';

    public function getId();

    public function setId($id) : RedirectInterface;

    public function setHost(string $host) : RedirectInterface;

    public function getHost();

    public function setRequestUrl(string $requestUrl) : RedirectInterface;

    public function getRequestUrl();

    public function setTargetUrl(string $targetUrl) : RedirectInterface;

    public function getTargetUrl();

    public function setRedirectCode(string $redirectCode) : RedirectInterface;

    public function getRedirectCode();
}
