<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Cron;

use FiloBlu\Refilo\Model\Deleter\ItemCleaner;
use Psr\Log\LoggerInterface;

class BeehiveCleanerJob
{
    /**
     * @var ItemCleaner
     */
    private $itemCleaner;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param ItemCleaner $itemCleaner
     * @param LoggerInterface $logger
     */
    public function __construct(
        ItemCleaner     $itemCleaner,
        LoggerInterface $logger
    )
    {
        $this->itemCleaner = $itemCleaner;
        $this->logger = $logger;
    }

    /**
     * Executes the BeehiveCleanerJob cron task.
     *
     * This method logs the start of the cron job, invokes the item cleaner to clean deleted items
     * for all configured indexers, and logs the completion or any errors encountered during execution.
     *
     * @return void
     */
    public function execute()
    {
        try {
            $this->logger->info('[BeehiveCleanerJob] Cron started');
            $this->itemCleaner->clean();
            $this->logger->info('[BeehiveCleanerJob] Cron completed successfully');
        } catch (\Throwable $e) {
            $this->logger->error('[BeehiveCleanerJob] Cron failed: ' . $e->getMessage());
            $this->logger->error($e->getTraceAsString());
        }
    }
}
