<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Form\Field;

use FiloBlu\Refilo\Block\Adminhtml\Option\ProductAttributeOptionSource;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\View\Element\Html\Select;

/**
 * Class Ranges
 */
class Attributes extends AbstractFieldArray
{
    /**
     * @var ProductAttributeOptionSource
     */
    private $productAttributeOptionSource;

    /**
     * Attributes constructor.
     * @param Context $context
     * @param ProductAttributeOptionSource $productAttributeOptionSource
     * @param array $data
     */
    public function __construct(
        Context $context,
        ProductAttributeOptionSource $productAttributeOptionSource,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->productAttributeOptionSource = $productAttributeOptionSource;
    }


    /**
     * Prepare rendering the new field by adding all the needed columns
     */
    protected function _prepareToRender()
    {
        $this->addColumn('filter', [
            'label'    => __('Filter'),
            'renderer' => $this->getLayout()->createBlock(Select::class)
                ->setId($this->_getCellInputElementId('<%- _id %>', 'filter'))
                ->setName($this->_getCellInputElementName('filter'))
                ->setClass('select')
                ->setOptions($this->productAttributeOptionSource->toOptionArray())
        ]);
        $this->addColumn('status', [
            'label'    => __('Status'),
            'renderer' => $this->getLayout()->createBlock(Select::class)
                ->setId($this->_getCellInputElementId('<%- _id %>', 'status'))
                ->setName($this->_getCellInputElementName('status'))
                ->setClass('select')
                ->setOptions([
                    [
                        'value' => '0',
                        'label' => 'No',

                    ],
                    [
                        'value' => '1',
                        'label' => 'Search',

                    ],
                    [
                        'value' => '2',
                        'label' => 'Search, Autocomplete',

                    ]
                ])
        ]);
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

}
