<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Indexer;

use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface;
use InvalidArgumentException;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;


/**
 *
 */
class MassDeleteOrder extends Action
{

    /**
     * @var IndexerConfigurationRepositoryInterface
     */
    private $indexerConfigurationRepository;
    /**
     * @var SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;

    /**
     * @param Context $context
     * @param IndexerConfigurationRepositoryInterface $indexerConfigurationRepository
     * @param SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory
     */
    public function __construct(
        Context                                 $context,
        IndexerConfigurationRepositoryInterface $indexerConfigurationRepository,
        SearchCriteriaBuilderFactory            $searchCriteriaBuilderFactory
    )
    {
        parent::__construct($context);
        $this->indexerConfigurationRepository = $indexerConfigurationRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     */
    public function execute()
    {
        $request = $this->getRequest();
        $order = (int)$request->getParam('delete_order');

        $excluded = $request->getParam('excluded');
        $selected = $request->getParam('selected');

        $searchCriteriaBuilder = $this->searchCriteriaBuilderFactory->create();

        if ($selected !== null) {
            $searchCriteriaBuilder->addFilter(IndexerConfigurationInterface::ID, $selected, 'in');
        }

        if ($excluded !== null) {
            $searchCriteriaBuilder->addFilter(IndexerConfigurationInterface::ID, $excluded, 'nin');
        }

        $result = $this->indexerConfigurationRepository->getList($searchCriteriaBuilder->create());

        /** @var IndexerConfigurationInterface $indexerConfiguration */
        foreach ($result->getItems() as $indexerConfiguration) {
            switch ($order) {
                case IndexerConfigurationInterface::DELETE_ORDER_BEFORE_INDEXER:
                    case IndexerConfigurationInterface::DELETE_ORDER_AFTER_INDEXER:
                    $indexerConfiguration->setDeleteOder($order);
                    $this->indexerConfigurationRepository->save($indexerConfiguration);
                    break;
                default:
                    throw new InvalidArgumentException('Unknow order');
            }

        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setPath('*/*/');
        return $resultRedirect;
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Refilo::Refilo');
    }
}
