<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Entity\Provider\Filter;

use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Catalog\Model\ResourceModel\Category\Collection;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Store\Api\Data\StoreInterface;

/**
 *
 */
class DisabledCategoryFilter implements DisabledEntityFilterInterface
{

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory
     */
    private $categoryCollectionFactory;

    /**
     * @param \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $categoryCollectionFactory
     */
    public function __construct(CollectionFactory $categoryCollectionFactory)
    {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
    }

    /**
     * @param \Magento\Store\Api\Data\StoreInterface|null $store
     * @return array
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getIds(StoreInterface $store = null): array
    {
        /** @var Collection $categoryCollection */
        $categoryCollection = $this->categoryCollectionFactory->create();

        return $categoryCollection->setStore($store)->addAttributeToFilter(
            CategoryInterface::KEY_IS_ACTIVE
        )->addFilter(
            CategoryInterface::KEY_IS_ACTIVE,
            '0'
        )->getAllIds() ?? [];
    }
}