<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote;

use Generator;

/**
 *
 */
class RunOnceDeleteItemFinder implements DeletedItemFinderInterface
{

    /**
     * @var array|null
     */
    private $deletedIds = null;
    /**
     * @var \FiloBlu\Refilo\Remote\DeletedItemFinderInterface
     */
    private $deletedItemFinder;

    /**
     * @param \FiloBlu\Refilo\Remote\DeletedItemFinderInterface $deletedItemFinder
     */
    public function __construct(DeletedItemFinderInterface $deletedItemFinder)
    {
        $this->deletedItemFinder = $deletedItemFinder;
    }


    /**
     * Returns the list of deleted IDs. This method will only return the deleted IDs once;
     * subsequent calls will return an empty array until the object is re-instantiated.
     *
     * @param mixed $ids Unused parameter, kept for interface compatibility.
     * @return array List of deleted IDs.
     */
    public function getDeletedIds($ids): array
    {
        if ($this->deletedIds === null) {
            $this->deletedIds = $this->deletedItemFinder->getDeletedIds($ids);
            return $this->deletedIds;
        }

        return [];
    }

    public function install()
    {
        $this->deletedItemFinder->install();
    }

    public function clean($ids)
    {
        $this->deletedItemFinder->clean($ids);
    }

    public function discover(): Generator
    {
        yield from $this->deletedItemFinder->discover();
    }
}
