<?php
/* author Raffaele Pugliese
created on 23/10/23  */


namespace FiloBlu\Refilo\Plugins;

use Magento\Quote\Model\Quote\Address;
use Magento\Quote\Model\Quote\Address\ToOrderAddress;
use Magento\Sales\Api\Data\OrderAddressInterface;

class ConvertQuoteAddressToOrderAddress
{
    /**
     * @param ToOrderAddress $subject
     * @param OrderAddressInterface $result
     * @param Address $object
     * @param array $data
     * @return OrderAddressInterface
     */
    public function afterConvert(ToOrderAddress $subject, OrderAddressInterface $result, Address $object, $data = [])
    {
        if ($object->getCareOf()) {
            $result->setData('care_of', $object->getCareOf());
        }
        return $result;
    }
}