<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model;


use FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface;
use Magento\Framework\DataObject;

/**
 *
 */
class ProductCustomOptionValue extends DataObject implements ProductCustomOptionValueInterface
{

    /**
     * @return int
     */
    public function getId(): int
    {
        return (int)$this->_getData(self::ID);
    }


    /**
     * @return string|null
     */
    public function getSku(): ?string
    {
        return $this->_getData(self::SKU);
    }

    /**
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->_getData(self::CODE);
    }

    /**
     * @return string|null
     */
    public function getLabel(): ?string
    {
        return $this->_getData(self::LABEL);
    }

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return (float)$this->_getData(self::PRICE);
    }


    /**
     * @param $id
     * @return \FiloBlu\Refilo\Model\ProductCustomOptionValue
     */
    public function setId($id): ProductCustomOptionValueInterface
    {
        return $this->setData(self::ID, $id);
    }

    /**
     * @param string|null $sku
     * @return \FiloBlu\Refilo\Model\ProductCustomOptionValue
     */
    public function setSku(?string $sku): ProductCustomOptionValueInterface
    {
        return $this->setData(self::SKU, $sku);
    }

    /**
     * @param string $code
     * @return \FiloBlu\Refilo\Model\ProductCustomOptionValue
     */
    public function setCode(string $code): ProductCustomOptionValueInterface
    {
        return $this->setData(self::CODE, $code);
    }

    /**
     * @param string|null $label
     * @return \FiloBlu\Refilo\Model\ProductCustomOptionValue
     */
    public function setLabel(?string $label): ProductCustomOptionValueInterface
    {
        return $this->setData(self::LABEL, $label);
    }

    /**
     * @param float $price
     * @return \FiloBlu\Refilo\Model\ProductCustomOptionValue
     */
    public function setPrice(float $price): ProductCustomOptionValueInterface
    {
        return $this->setData(self::PRICE, $price);
    }

}
