<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Data\Remote;

use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class IndexerDeleteOrder
 * @package FiloBlu\Refilo\Data\Remote
 */
class IndexerDeleteOrderOptions implements OptionSourceInterface
{
    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'label' => __('Delete before reindex'),
                'value' => IndexerConfigurationInterface::DELETE_ORDER_BEFORE_INDEXER
            ],
            [
                'label' => __('Delete after reindex'),
                'value' => IndexerConfigurationInterface::DELETE_ORDER_AFTER_INDEXER
            ],
        ];
    }
}
