<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Cron;

use Exception;
use FiloBlu\Refilo\Remote\RatingIndexer;

/**
 * Class Cron
 * @package FiloBlu\Flow\Cron
 */
class Cron
{
    /**
     * @var RatingIndexer
     */
    private $ratingIndexer;

    /**
     * @param RatingIndexer $ratingIndexer
     */
    public function __construct(
        RatingIndexer $ratingIndexer
    )
    {
        $this->ratingIndexer = $ratingIndexer;
    }

    /**
     * @return $this
     * @throws Exception
     */
    public function ratingIndexer(): Cron
    {
        $this->ratingIndexer->executeFull();
        return $this;
    }

}
