/*eslint-disable */
define([], function () {
    /**
     * Copyright © Magento, Inc. All rights reserved.
     * See COPYING.txt for license details.
     */

    /**
     * @api
     */
    var Spacings =
        /*#__PURE__*/
        function () {
            "use strict";

            function Spacings() {
            }

            var _proto = Spacings.prototype;

            /**
             * Read margins from element
             *
             * @param {HTMLElement} element
             * @returns {string | object}
             */
            _proto.read = function read(element) {

                var marginData = element.dataset.mobileMargin
                var paddingData = element.dataset.mobilePadding
                if (marginData !== undefined && paddingData !== undefined) {
                    var marginArray = marginData.split(" ")
                    var paddingArray = paddingData.split(" ")

                    if (marginArray.length > 1 && paddingArray > 1) {
                        return {
                            mobileMargin: {
                                Top: marginArray[0].replace("px", ""),
                                Right: marginArray[1].replace("px", ""),
                                Bottom: marginArray[2].replace("px", ""),
                                Left: marginArray[3].replace("px", "")
                            },
                            mobilePadding: {
                                Top: paddingArray[0].replace("px", ""),
                                Right: paddingArray[1].replace("px", ""),
                                Bottom: paddingArray[2].replace("px", ""),
                                Left: paddingArray[3].replace("px", "")
                            }
                        };
                    }
                }


                return ""
            };

            return Spacings;
        }();

    return Spacings;
});
//# sourceMappingURL=margins.js.map
