<?php

namespace FiloBlu\Refilo\Ui\Component\Indexer\Listing;

use FiloBlu\Core\Framework\Ui\AbstractDataProvider;
use FiloBlu\Refilo\Remote\Connector\ConnectorPool;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepository;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Ui\DataProvider\Modifier\PoolInterface;

/**
 * Class DataProvider
 * @package FiloBlu\Refilo\Ui\Component\Connector\Form
 */
class DataProvider extends AbstractDataProvider
{

    /**
     * @var PoolInterface
     */
    private $modifierPool;
    /**
     * @var ConnectorPool
     */
    private $connectorPool;
    /**
     * @var IndexerConfigurationRepository
     */
    private $indexerConfigurationRepository;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param IndexerConfigurationRepository $indexerConfigurationRepository
     * @param ConnectorPool $connectorPool
     * @param FilterBuilder $filterBuilder
     * @param RequestInterface $request
     * @param PoolInterface $modifierPool
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        IndexerConfigurationRepository $indexerConfigurationRepository,
        ConnectorPool $connectorPool,
        FilterBuilder $filterBuilder,
        RequestInterface $request,
        PoolInterface $modifierPool,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct(
            $name,
            $primaryFieldName,
            $requestFieldName,
            $searchCriteriaBuilder,
            $filterBuilder,
            $request,
            $meta,
            $data
        );

        $this->modifierPool = $modifierPool;
        $this->connectorPool = $connectorPool;
        $this->indexerConfigurationRepository = $indexerConfigurationRepository;
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        return [
            'totalRecords' => $this->count(),
            'items'        => $this->getSearchResult()->getItems()
        ];
    }

    /**
     * @return int
     */
    public function count()
    {
        return $this->indexerConfigurationRepository->count($this->getSearchCriteria(), true);
    }

    /**
     * @return SearchResultInterface|SearchResultsInterface
     */
    public function getSearchResult()
    {
        return $this->indexerConfigurationRepository->getList($this->getSearchCriteria(), true);
    }
}
