<?php

namespace FiloBlu\Refilo\Ui\Component\Connector\Listing\Column;

use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Actions
 * @package FiloBlu\Refilo\Ui\Component\Connector\Listing\Column
 */
class Actions extends Column
{
    /**
     * Prepare Data Source.
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $item[$this->getData('name')] = [
                    'edit' => [
                        'href'  => $this->context->getUrl(
                            'filoblu_refilo/connector/edit',
                            ['id' => $item['id']]
                        ),
                        'label' => __('Edit')
                    ]
                ];
            }
        }

        return $dataSource;
    }
}

