<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote;

/**
 * Class StockIndexer
 * @package FiloBlu\Refilo\Remote
 */
class StockIndexer extends AbstractWebsiteBasedIndexer
{
    /**
     * @param $entities
     * @param $collection
     * @return void
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function write($entities, $collection)
    {
        parent::write(
            $this->getIndexerHelper()->hideOutOfStocks(
                $entities,
                $this->getStoreManager()->getStore()
            ),
            $collection
        );
    }

    /**
     * @return string
     */
    protected function getClass(): string
    {
        return __CLASS__;
    }
}

