<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Entity;

/**
 *
 */
class UrlRewrite extends AbstractEntity
{
    /**
     *
     */
    public const URL_ID = 'url_id';
    /**
     *
     */
    public const TYPE = 'type';
    /**
     *
     */
    public const ENTITY_ID = 'entity_id';
    /**
     *
     */
    public const URL = 'url';
    /**
     *
     */
    public const IS_REDIRECT = 'is_redirect';
    /**
     *
     */
    public const TARGET_URL = 'target_url';
    /**
     *
     */
    public const STORE = 'store';
    /**
     *
     */
    public const HREFLANG = 'hreflang';
    /**
     *
     */
    public const PAGE_IDENTIFIER = 'page_identifier';
    /**
     *
     */
    public const CATEGORY_IDENTIFIER = 'category_identifier';
    /**
     *
     */
    public const CANONICAL = 'canonical';
    /**
     *
     */
    public const BREADCRUMBS = 'breadcrumbs';

    /**
     * @param array $array
     * @return $this
     */
    public function setBreadcrumbs(array $array): UrlRewrite
    {
        $this->setData(self::BREADCRUMBS, $array);
        return $this;
    }

    /**
     * @param array $hreflang
     * @return $this
     */
    public function setHreflang(array $hreflang): UrlRewrite
    {
        $this->setData(self::HREFLANG, $hreflang);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getType()
    {
        return $this->getData(self::TYPE);
    }

    /**
     * @return array|mixed|null
     */
    public function getTargetUrl()
    {
        return $this->getData(self::TARGET_URL);
    }

    /**
     * @return string|null
     */
    public function getPageIdentifier()
    {
        return $this->getData(self::PAGE_IDENTIFIER);
    }

    /**
     * @return string|null
     */
    public function getCategoryIdentifier()
    {
        return $this->getData(self::CATEGORY_IDENTIFIER);
    }

    /**
     * @return array|mixed|null
     */
    public function getStore()
    {
        return $this->getData(self::STORE);
    }

    /**
     * @param string $storeCode
     * @return $this
     */
    public function setStore(string $storeCode): UrlRewrite
    {
        $this->setData(self::STORE, $storeCode);
        return $this;
    }

    /**
     * @param string|null $canonical
     * @return $this
     */
    public function setCanonical(string $canonical = null): UrlRewrite
    {
        $this->setData(self::CANONICAL, $canonical);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @param string $isRedirect "0", "301", "302"
     * @return $this
     */
    public function setIsRedirect($isRedirect): UrlRewrite{
        $this->setData(self::IS_REDIRECT, $isRedirect);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getIsRedirect() {
        return $this->getData(self::IS_REDIRECT);
    }

    /**
     * @param $type
     * @return $this
     */
    public function setType($type) : UrlRewrite{
        $this->setData(self::TYPE, $type);
        return $this;
    }

    /**
     * @param $url
     * @return $this
     */
    public function setTargetUrl($url) : UrlRewrite{
        $this->setData(self::TARGET_URL, $url);
        return $this;
    }
}
