<?php

namespace FiloBlu\Refilo\Remote\Entity;

use Generator;
use Iterator;
use Magento\Framework\DataObject;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Store\Api\Data\WebsiteInterface;

/**
 * Interface EntityProviderInterface
 * @package FiloBlu\Refilo\Remote
 */
interface EntityProviderInterface extends Iterator
{

    /**
     * @param array $ids
     * @return EntityProviderInterface
     */
    public function withIds(array $ids): EntityProviderInterface;

    /**
     * @param StoreInterface $store
     * @return EntityProviderInterface
     */
    public function forStore(StoreInterface $store): EntityProviderInterface;

    /**
     * @param WebsiteInterface $website
     * @return EntityProviderInterface
     */
    public function forWebsite(WebsiteInterface $website): EntityProviderInterface;

    /**
     * @param EntityProviderReaderHandlerInderface $handler
     * @param DataObject|null $arguments
     * @return EntityProviderInterface
     */
    public function attachReaderHandler(EntityProviderReaderHandlerInderface $handler, DataObject $arguments = null) : EntityProviderInterface;

    /**
     * @return EntityProviderReaderHandlerInderface
     */
    public function detachReaderHandler() : EntityProviderReaderHandlerInderface;

    /**
     * @return Generator
     */
    public function toGenerator(): Generator;

    /**
     * @return EntityProviderInterface
     */
    public function prepare(): EntityProviderInterface;

    /**
     * @return EntityProviderInterface
     */
    public function release(): EntityProviderInterface;
}
