<?php

namespace FiloBlu\Refilo\Remote\Connector;

use FiloBlu\Core\Framework\Model\RepositoryItem;
use Magento\Framework\DataObject;
use Magento\Framework\DataObjectFactory;

/**
 * Class ConnectorConfiguration
 * @package FiloBlu\Refilo\Remote\Connector
 */
class ConnectorConfiguration implements ConnectorConfigurationInterface
{
    /**
     * @var string|int
     */
    protected $id;

    /**
     * @var DataObject
     */
    protected $configuration;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var ConnectorInterface
     */
    protected $connector;

    /**
     * @var DataObjectFactory
     */
    private $dataObjectFactory;

    /**
     * ConnectorConfiguration constructor.
     * @param DataObjectFactory $dataObjectFactory
     */
    public function __construct(DataObjectFactory $dataObjectFactory)
    {
        $this->dataObjectFactory = $dataObjectFactory;
    }

    /**
     * @return int|string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param $id
     * @return $this|RepositoryItem
     */
    public function setId($id): RepositoryItem
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param $name
     * @return $this|ConnectorConfigurationInterface
     */
    public function setName($name): ConnectorConfigurationInterface
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return ConnectorInterface
     */
    public function getConnector(): ConnectorInterface
    {
        return $this->connector->configure($this->getConfiguration());
    }

    /**
     * @param ConnectorInterface $connector
     * @return $this|ConnectorConfigurationInterface
     */
    public function setConnector(ConnectorInterface $connector): ConnectorConfigurationInterface
    {
        $this->connector = $connector;
        return $this;
    }

    /**
     * @return DataObject
     */
    public function getConfiguration(): DataObject
    {
        if ($this->configuration !== null) {
            return $this->configuration;
        }

        return ($this->configuration = $this->dataObjectFactory->create());
    }

    /**
     * @param DataObject $configuration
     * @return $this|ConnectorConfigurationInterface
     */
    public function setConfiguration(DataObject $configuration): ConnectorConfigurationInterface
    {
        $this->configuration = $configuration;
        return $this;
    }

}
