<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Plugins\Block\Product;

use FiloBlu\Refilo\Helper\Data;
use Magento\Catalog\Block\Product\AbstractProduct;
use Magento\Catalog\Model\Product;

/**
 * @class AbstractProductPlugin
 * @package FiloBlu\Refilo\Plugins
 */
class AbstractProductRendererPlugin
{

    /**
     * @var Data
     */
    public $helper;

    /**
     * @param Data $helper
     */
    public function __construct(Data $helper)
    {
        $this->helper = $helper;
    }

    /**
     * @param AbstractProduct $subject
     * @param $result
     * @param Product $product
     * @return string
     * @see \Magento\Catalog\Block\Product\AbstractProduct::getProductDetailsHtml
     */
    public function afterGetProductDetailsHtml(AbstractProduct $subject, $result, Product $product)
    {
        if (!$this->helper->getEnableFilteringByWebsiteOnProductWidgetCollection()) {
            return $result;
        }

        return '';
    }
}
