<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Api\CartManagementInterface;

/**
 *
 */
class CheckoutSubmitBeforeObserver implements ObserverInterface
{
    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $quote = $observer->getData('quote');

        if ($quote->getCheckoutMethod() === CartManagementInterface::METHOD_GUEST) {
            $quote->setCustomerFirstname($quote->getBillingAddress()->getFirstname());
            $quote->setCustomerLastname($quote->getBillingAddress()->getLastname());
            if ($quote->getBillingAddress()->getMiddlename() === null) {
                $quote->setCustomerMiddlename($quote->getBillingAddress()->getMiddlename());
            }
        }
    }

}
