<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

/**
 *
 */
interface ShippingEstimationResolverInterface
{
    /**
     * @param $store
     * @return bool
     */
    public function hasStrategyForStore($store): bool;

    /**
     * @param int|string $store
     * @return \FiloBlu\Refilo\Model\ShippingEstimationStrategyInterface
     * @throws \Exception
     */
    public function getByStore($store): ShippingEstimationStrategyInterface;

    /**
     * @return array
     */
    public function getAll(): array;
}
