<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\ResourceModel\Translate;

/**
 *
 */
class Translate extends \Magento\Translation\Model\ResourceModel\Translate
{

    /**
     * Retrieve translation array for store / locale code
     *
     * @param int $storeId
     * @param string $locale
     *
     * @return array
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getTranslationArray($storeId = null, $locale = null)
    {
        if ($storeId === null) {
            $storeId = $this->getStoreId();
        }
        $locale = (string) $locale;

        $storeCode = $this->scopeResolver->getScope($storeId)
                                         ->getCode()
        ;
        //        $data = $this->appConfig->get(
        //            Translation::CONFIG_TYPE,
        //            $locale . '/' . $storeCode,
        //            []
        //        );
        $connection = $this->getConnection();

            $select = $connection->select()
                                 ->from($this->getMainTable(), ['string', 'translate'])
                                 ->where('store_id IN (0 , :store_id)')
                                 ->where('locale = :locale')
                                 ->where('is_frontend_label = 1')
                                 ->order('store_id');
            $bind = [':locale' => $locale, ':store_id' => $storeId];
        // $data = array_replace($data, $dbData);

        return array_map(static function ($value) {
            return htmlspecialchars_decode($value ?? '');
        }, $connection->fetchPairs($select, $bind));
    }
}
