<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

use FiloBlu\Refilo\Api\Data\CustomerOrderRequestInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * @package FiloBlu\Refilo\Model
 * @class CustomerOrderRequest
 */
class CustomerOrderRequest extends AbstractModel implements CustomerOrderRequestInterface
{
    /**
     * @return string
     */
    public function getCustomerId()
    {
        return $this->getData(self::CUSTOMER_ID);
    }

    /**
     * @param string $customerId
     * @return $this
     */
    public function setCustomerId($customerId)
    {
        $this->setData(self::CUSTOMER_ID, $customerId);
        return $this;
    }

    /**
     * @param string $orderId
     * @return $this|mixed
     */
    public function setOrderId($orderId)
    {
        $this->setData(self::ORDER_ID, $orderId);
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->getData(self::ORDER_ID);
    }

    /**
     * @param int $storeId
     * @return $this|mixed
     */
    public function setStoreId($storeId)
    {
        $this->setData(self::STORE_ID, $storeId);
        return $this;
    }

    /**
     * @return int
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * @return int
     */
    public function getPageSize()
    {
        return $this->getData(self::PAGE_SIZE);
    }

    /**
     * @param int $pageSize
     * @return $this|mixed
     */
    public function setPageSize($pageSize)
    {
        $this->setData(self::PAGE_SIZE, $pageSize);
        return $this;
    }

    /**
     * @return int
     */
    public function getPageNumber()
    {
        return $this->getData(self::PAGE_NUMBER);
    }

    /**
     * @param int $pageNumber
     * @return $this|mixed
     */
    public function setPageNumber($pageNumber)
    {
        $this->setData(self::PAGE_NUMBER, $pageNumber);
        return $this;
    }

    /**
     * @param $orderField
     * @return $this|mixed
     */
    public function setOrderField($orderField)
    {
        $this->setData(self::ORDER_FIELD, $orderField);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getOrderField()
    {
        return $this->getData(self::ORDER_FIELD);
    }

    /**
     * @param $orderDirection
     * @return $this|mixed
     */
    public function setOrderDirection($orderDirection)
    {
        $this->setData(self::ORDER_DIRECTION, $orderDirection);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getOrderDirection()
    {
        return $this->getData(self::ORDER_DIRECTION);
    }
}
