<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Config\Seo;

use Magento\Store\Api\Data\StoreInterface;
use Magento\Store\Model\Store;

/**
 *
 */
interface HrefLangConfigurationSourceInterface
{

    /**
     * @param int|string|StoreInterface|Store $store
     * @return bool
     */
    public function isEnabledForCategory($store = 0): bool;

    /**
     * @param int|string|StoreInterface|Store $store
     * @return bool
     */
    public function isEnabledForProduct($store = 0): bool;

    /**
     * @param int|string|StoreInterface|Store $store
     * @return bool
     */
    public function isEnabledForCms($store = 0): bool;

    /**
     * @param $store
     * @return bool
     */
    public function isEnabledForHome($store = 0): bool;

    /**
     * @param $store
     * @return bool
     */
    public function getLanguageCode($store = 0);

    /**
     * @param $store
     * @return bool
     */
    public function usesCanonical($store = 0): bool;

    /**
     * @param $store
     * @return mixed
     */
    public function getCanonicalStore($store);
}
