<?php


namespace FiloBlu\Refilo\Model\Config\ContentType\AdditionalData\Provider;

use Magento\Framework\UrlInterface;
use Magento\PageBuilder\Model\Config\ContentType\AdditionalData\ProviderInterface;

class ContentDataUrl implements ProviderInterface
{
    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    /**
     * BlockDataUrl constructor.
     * @param UrlInterface $urlBuilder
     */
    public function __construct(UrlInterface $urlBuilder)
    {
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @inheritdoc
     */
    public function getData(string $itemName) : array
    {
        return [$itemName => $this->urlBuilder->getUrl('filoblu_refilo/contenttype_content/metadata')];
    }
}
