<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Config;

use Magento\Framework\DataObject;
use Magento\Store\Api\Data\StoreInterface;

/**
 * Interface ConfigProviderInterface
 * @package FiloBlu\Refilo\Model\Config
 */
interface ConfigProviderInterface
{

    const DEFAULT = 'default';

    /**
     * @param DataObject $configurations
     * @param \Magento\Store\Api\Data\StoreInterface|null $store
     * @return mixed
     */
    public function getConfigs(DataObject $configurations, StoreInterface $store = null);

}
