<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

use Exception;
use Magento\Customer\Model\AccountManagementApi;
use Magento\Framework\Exception\NoSuchEntityException;
use Throwable;

/**
 *
 */
class AccountManagmentApi extends AccountManagementApi
{

    /**
     * @inheritdoc
     * @throws Exception
     */
    public function resetPassword($email, $resetToken, $newPassword)
    {
        try{
            return parent::resetPassword($email, $resetToken, $newPassword);
        } catch (Throwable $exception) {
            throw new Exception('Unable to change password');
        }
    }

    /**
     * @inheritdoc
     * @throws Exception
     */
    public function initiatePasswordReset($email, $template, $websiteId = null)
    {
        try{
            return parent::initiatePasswordReset($email, $template, $websiteId);
        } catch (Throwable $exception) {
            $this->logger->error($exception);
            throw new NoSuchEntityException(__('If there is an account associated to this email address you will receive an email with instructions to set a new password'));
        }
    }
}