<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Redirects;

use Exception;
use FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectsRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;

/**
 *
 */
class MassDelete extends Action
{
    /**
     * @var RedirectsRepositoryInterface
     */
    protected $redirectRepository;

    /**
     * Delete constructor.
     * @param Context $context
     * @param RedirectsRepositoryInterface $redirectRepository
     */
    public function __construct(Context $context, RedirectsRepositoryInterface $redirectRepository)
    {
        parent::__construct($context);
        $this->redirectRepository = $redirectRepository;
    }

    /**
     * @return ResultInterface
     */
    public function execute()
    {
        $ids = $this->getRequest()->getParam('selected', null);
        if ($ids === null) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        foreach ($ids as $id) {
            try {
                $this->redirectRepository->deleteById($id);
                $this->messageManager->addSuccessMessage(__('Deleted Redirect with id %1', $id));
            } catch (Exception $exception) {
                $this->messageManager->addExceptionMessage($exception);
            }
        }

        return $this->resultRedirectFactory->create()->setPath('*/*/');
    }
}
