<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\Translations as TranslationsExporter;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Message\ManagerInterface;

/**
 *
 */
class Translations implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var TranslationsExporter
     */
    private $translationsExporter;


    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param TranslationsExporter $translationsExporter
     */
    public function __construct(
        ResultFactory        $resultFactory,
        ManagerInterface     $messageManager,
        TranslationsExporter $translationsExporter
    )
    {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->translationsExporter = $translationsExporter;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     */
    public function execute()
    {
        try {
            $this->translationsExporter->export();
            $this->messageManager->addSuccessMessage(__('Translations successfully synced'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }

}
