<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\Storelocator as StorelocatorExporter;
use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Message\ManagerInterface;

/**
 *
 */
class Storelocator implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var StorelocatorExporter
     */
    private $storeLocatorExporter;

    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param StorelocatorExporter $storeLocatorExporter
     */
    public function __construct(
        ResultFactory        $resultFactory,
        ManagerInterface     $messageManager,
        StorelocatorExporter $storeLocatorExporter
    )
    {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->storeLocatorExporter = $storeLocatorExporter;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     */
    public function execute()
    {
        try {
            $this->storeLocatorExporter->export();
            $this->messageManager->addSuccessMessage(__('Store locator data successfully synced'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }

}
