<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Connector;

use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterfaceFactory;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface;
use FiloBlu\Refilo\Remote\Connector\ConnectorPool;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\DataObjectFactory;
use Magento\Framework\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Edit
 * @package FiloBlu\Refilo\Controller\Adminhtml\Connector
 */
class Edit extends Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;
    /**
     * @var ConnectorConfigurationRepositoryInterface
     */
    private $connectorRepository;
    /**
     * @var ConnectorPool
     */
    private $connectorPool;
    /**
     * @var DataObjectFactory
     */
    private $dataObjectFactory;
    /**
     * @var ConnectorConfigurationInterfaceFactory
     */
    private $connectorConfigurationFactory;

    /**
     * Index constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param ConnectorConfigurationRepositoryInterface $connectorRepository
     * @param ConnectorConfigurationInterfaceFactory $connectorConfigurationFactory
     * @param ConnectorPool $connectorPool
     * @param DataObjectFactory $dataObjectFactory
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        ConnectorConfigurationRepositoryInterface $connectorRepository,
        ConnectorConfigurationInterfaceFactory $connectorConfigurationFactory,
        ConnectorPool $connectorPool,
        DataObjectFactory $dataObjectFactory
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->connectorRepository = $connectorRepository;
        $this->connectorPool = $connectorPool;
        $this->dataObjectFactory = $dataObjectFactory;
        $this->connectorConfigurationFactory = $connectorConfigurationFactory;
    }

    /**
     * @return ResponseInterface|ResultInterface|Page
     */
    public function execute()
    {
        $request = $this->getRequest();
        $data = $request->getParams();

        $id = $request->getParam(ConnectorConfigurationInterface::ID, null);

        if (isset($data['configuration'])) {
            $connector = $this->connectorPool->get($data['type']);

            /** @var ConnectorConfigurationInterface $connectorConfiguration */
            $connectorConfiguration = $this->connectorConfigurationFactory->create();

            $connectorConfiguration->setName($data['name'])->setConnector($connector);

            if ($id !== null) {
                $connectorConfiguration->setId($id);
            }

            $connectorConfiguration->setConfiguration(
                $this->dataObjectFactory->create(['data' => $data['configuration']])
            );
            $connectorConfiguration = $this->connectorRepository->save($connectorConfiguration);
            $id = $connectorConfiguration->getId();
        }

        $params = $id ? ['id' => $id] : [];
        $backTo = $this->getRequest()->getParam('back', false);

        if ($backTo) {
            return $this->resultRedirectFactory->create()->setPath("*/*/$backTo", $params);
        }

        if ($request->isPost()) {
            return $this->resultRedirectFactory->create()->setPath('*/*/', $params);
        }

        return $this->resultPageFactory->create();
    }
}
