<?php

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\Menu;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportMenu extends Command {
    const NAME = 'name';
    /**
     * @var Menu
     */
    private $countries;
    /**
     * @var Menu
     */
    private $menu;

    /**
     * ImportBlocks constructor.
     * @param Menu $menuBlock
     * @param string $name
     */
    public function __construct(
        Menu $menuBlock,
        string $name = null
    ) {
        $this->menu = $menuBlock;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:menu');
        $this->setDescription('Import Menu');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->menu->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
