<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Option;

use FiloBlu\Refilo\Model\ShippingEstimationResolverInterface;
use Magento\Framework\Data\OptionSourceInterface;

/**
 *
 */
class ShippingEstimationOptionSource implements OptionSourceInterface
{
    /**
     * @var \FiloBlu\Refilo\Model\ShippingEstimationResolverInterface
     */
    private $estimationResolver;

    /**
     * @param \FiloBlu\Refilo\Model\ShippingEstimationResolverInterface $estimationResolver
     */
    public function __construct(ShippingEstimationResolverInterface $estimationResolver)
    {
        $this->estimationResolver = $estimationResolver;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];

        foreach (array_keys($this->estimationResolver->getAll()) as $key) {
            $options[] = [
                'label' => __($key),
                'value' => $key
            ];
        }

        return $options;
    }
}