<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api;

/**
 * Interface for merging guest cart into the active cart of the customer.
 *
 * Scenario:
 * - Guest is adding items to cart
 * - Guest logs in and becomes a customer, which might have existing cart from previous session
 * - Guest cart needs to be merged into customer's existing cart
 *
 * @link https://github.com/adobe/commerce-cif-magento-extension
 */
interface MergeCartsInterface
{
    /**
     * Merge guest cart into active customer cart.
     *
     * @param int $userId
     * @param string $storeCode
     * @param int $customerCartId
     * @param string $guestCartId Guest cart ID hash
     * @return int Customer cart ID
     */
    public function mergeGuestCartIntoActiveCustomerCart(
        $userId,
        $storeCode,
        $customerCartId,
        $guestCartId
    );
}
