<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api;

use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 *
 */
interface CustomerGroupManagmentInterface
{
    /**
     * Update Customer Group and relative quote data
     *
     * @param int $customerId
     * @param int $customerGroupId
     * @return \Magento\Customer\Api\Data\CustomerInterface
     */
    public function updateCustomerGroup(int $customerId, int $customerGroupId);


    /**
     * Create customer account with CustomerGroupId. Perform necessary business operations like sending email.
     *
     * @param \Magento\Customer\Api\Data\CustomerInterface $customer
     * @param string $password
     * @param string $redirectUrl
     * @param int $customerGroupId
     * @return \Magento\Customer\Api\Data\CustomerInterface
     * @throws LocalizedException
     */
    public function createAccount(
        CustomerInterface $customer,
        $password = null,
        $redirectUrl = '',
        $customerGroupId = null
    );


}
