<?php

namespace FiloBlu\Refilo\Ui\Component\Connector\Listing;

use FiloBlu\Core\Framework\Ui\AbstractDataProvider;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Ui\DataProvider\Modifier\PoolInterface;

/**
 * Class DataProvider
 * @package FiloBlu\Refilo\Ui\Component\Connector\Listing
 */
class DataProvider extends AbstractDataProvider
{

    /**
     * @var ConnectorConfigurationRepositoryInterface
     */
    private $connectorConfigurationRepository;
    /**
     * @var PoolInterface
     */
    private $modifierPool;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param FilterBuilder $filterBuilder
     * @param RequestInterface $request
     * @param PoolInterface $modifierPool
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        RequestInterface $request,
        PoolInterface $modifierPool,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct(
            $name,
            $primaryFieldName,
            $requestFieldName,
            $searchCriteriaBuilder,
            $filterBuilder,
            $request,
            $meta,
            $data
        );

        $this->connectorConfigurationRepository = $connectorConfigurationRepository;
        $this->modifierPool = $modifierPool;
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        $items = $this->getSearchResult()->getItems();

        return [
            'totalRecords' => count($items),
            'items'        => $items
        ];
    }

    /**
     * @return SearchResultInterface|\Magento\Framework\Api\SearchResultsInterface
     */
    public function getSearchResult()
    {
        return $this->connectorConfigurationRepository->getList($this->getSearchCriteria(), true);
    }

    /**
     * @return int
     */
    public function count()
    {
        return  $this->connectorConfigurationRepository->count($this->getSearchCriteria(), true);
    }
}
