<?php

use FiloBlu\Refilo\Remote\Entity\Provider\PriceProvider;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\State;
use Magento\Store\Model\StoreManagerInterface;

require __DIR__ . '/../../../../../app/bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$obj = $bootstrap->getObjectManager();
$state = $obj->get(State::class);
$state->setAreaCode('adminhtml');
$objectManager = ObjectManager::getInstance();

/** @var StoreManagerInterface $storeManager */
$storeManager = $objectManager->get(StoreManagerInterface::class);
/** @var PriceProvider $priceProvider */
$priceProvider = $objectManager->get(PriceProvider::class);

foreach ($priceProvider->forStore($storeManager->getStore()) as $product) {
    echo json_encode($product->toArray(), JSON_PRETTY_PRINT) . PHP_EOL;
    exit(0);
}

/**
 *
 *array (
 * 'pricing_0' =>
 * array (
 * 'final_price' => 0.0,
 * 'max_price' => 0.0,
 * 'min_price' => 0.0,
 * 'base_price' => 0.0,
 * ),
 * 'id' => 36,
 * )
 */
