<?php

namespace FiloBlu\Refilo\Remote\Helper;

/**
 * Class TemplateString
 * @package FiloBlu\Refilo\Remote\Helper
 */
class TemplateString
{
    /**
     * @var string
     */
    protected $string = '';
    /**
     * @var array
     */
    protected $values = [];

    /**
     * @param array $values key => value
     * @return $this
     */
    public function withValues(array $values): TemplateString
    {
        $this->values = array_merge($this->values, $values);
        return $this;
    }

    /**
     * @param string $key
     * @param string $value
     * @return $this
     */
    public function withValue(string $key, string $value): TemplateString
    {
        $this->values[$key] = $value;
        return $this;
    }

    /**
     * @param string $string
     * @return $this
     */
    public function withString(string $string): TemplateString
    {
        $this->string = $string;
        return $this;
    }

    /**
     * @return string
     */
    public function render(): string
    {
        return str_replace(
            array_keys($this->values),
            array_values($this->values),
            $this->string
        );
    }
}
