<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Entity;

use Exception;
use FiloBlu\Refilo\Helper\Catalog\ProductHelper;
use Magento\Catalog\Api\Data\ProductInterface;

/**
 *
 */
class MagentoToDisabledRefiloProductAdapter
{
    /**
     * @var ProductHelper
     */
    private $productHelper;

    /**
     * @param ProductHelper $productHelper
     */
    public function __construct(ProductHelper $productHelper)
    {
        $this->productHelper = $productHelper;
    }

    /**
     * @param \Magento\Catalog\Model\Product|ProductInterface $magentoProduct
     * @param Product $refiloProduct
     * @return Product
     * @throws Exception
     */
    public function adapt($magentoProduct, Product $refiloProduct): Product
    {
        $storeId = $magentoProduct->getStore()->getId();
        $attributes = $this->productHelper->getProductAttributeHelper()->getAttributes();

        $refiloProduct->setData([
            Product::DOCTYPE    => Product::DOCTYPE_SPEC_DISABLED,
            AbstractEntity::ID  => (int)$magentoProduct->getEntityId(),
            Product::ENABLED    => '0',
            Product::SKU        => $magentoProduct->getSku(),
            Product::TYPE       => $magentoProduct->getTypeId(),
            Product::NAME       => $magentoProduct->getName(),
            Product::CREATED_AT => $magentoProduct->getCreatedAt(),
            Product::UPDATED_AT => $magentoProduct->getUpdatedAt(),
            Product::ASSETS     => $this->productHelper->getAssets($magentoProduct),
            Product::ATTRIBUTES => [
                'url_key' => [
                    'value' => $magentoProduct->getUrlKey(),
                    'title' => $attributes[$storeId]['url_key']['title'] ?? 'Url Key'
                ],
                'name'    => [
                    'value' => $magentoProduct->getName(),
                    'title' => $attributes[$storeId]['name']['title'] ?? 'Title'
                ]
            ]
        ]);

        return $refiloProduct;
    }
}
