<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Remote;

/**
 * Class StockIndexer
 * @package FiloBlu\Refilo\Remote
 */
class CategoryPermissionsIndexer extends AbstractWebsiteBasedIndexer
{
    /**
     * @param array $ids
     * @return void
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function executeAction(array $ids)
    {
        if (!$this->getScopeConfig()->isSetFlag('catalog/magento_catalogpermissions/enabled')) {
            return;
        }

        parent::executeAction($ids);
    }

    /**
     * @return string
     */
    protected function getClass(): string
    {
        return __CLASS__;
    }
}

