# Refilo Release Notes

**Version:** `0.1.0`

---

### 🆕 New Deleter Strategy

A new deleter strategy has been introduced to handle the deletion of items in Refilo.

- **Entry Point:** `\FiloBlu\Refilo\Setup\RecurringData::updateTrigger`
- During `setup:upgrade`, a delete trigger is added to Magento tables for indexers using `BaseSqlDeletedItemFinder`.
- The corresponding `{indexer}_deleted_item_cl` table is created using:
  ```php
  \FiloBlu\Refilo\Remote\BaseSqlDeletedItemFinder::install
  ```

During **partial indexing**, the deleter strategy is defined in the implementation of:

```php
\FiloBlu\Refilo\Remote\DeletedItemFinderInterface::clean
```

For example, `BaseSqlDeletedItemFinder` implements the `clean()` method to delete IDs from the related Deleter_ChangeLog tables.

---

### 🕒 New Cron Job: `\FiloBlu\Refilo\Cron\BeehiveCleanerJob`

A new cron job `BeehiveCleanerJob` has been introduced to automate the cleaning of deleted items for all configured Refilo indexers.

- **Cron class:** `\FiloBlu\Refilo\Cron\BeehiveCleanerJob`
- **Runs:** Daily between `2:00 AM` and `4:00 AM` (default is `3:00 AM`, configurable via `crontab.xml`)
- **Service used:** `\FiloBlu\Refilo\Model\Deleter\ItemCleaner`
- **Behavior:**
    - Automatically retrieves all Refilo indexers and calls `cleanByIndexer()` on each
    - Logs both start and completion of the cleaning process
    - Logs any exceptions that occur for easier troubleshooting

This ensures that deleted items are regularly and automatically cleaned from the system without manual intervention.

---

### 🛠️ New CLI Command: `refilo:indexer:clean`

A new CLI command `refilo:clean:indexer` has been added to clean deleted items from all Refilo indexers or a specific indexer.

#### 🔧 Usage

- Clean **all** indexers:
  ```bash
  bin/magento refilo:indexer:clean
  ```

- Clean a **specific** indexer:
  ```bash
  bin/magento refilo:indexer:clean <indexer_code>
  ```

#### 🧾 Arguments

- `indexer` (optional): The code of the indexer to clean (e.g. `beehive_product`)

#### 📌 Description

- When run **without arguments**, the command cleans all configured Refilo indexers by calling:
  ```php
  \FiloBlu\Refilo\Model\Deleter\ItemCleaner::clean()
  ```
- When an **indexer code** is provided, only the specified indexer is cleaned using:
  ```php
  \FiloBlu\Refilo\Model\Deleter\ItemCleaner::cleanByIndexer(AbstractIndexer $indexer)
  ```
- The command:
    - Loads the Magento indexer by code
    - Resolves the corresponding `actionClass`
    - Verifies that the class is an instance of `\FiloBlu\Refilo\Remote\AbstractIndexer`
    - Instantiates the class via Magento ObjectManager
    - Executes the cleanup

- Success and error messages are displayed in the CLI output.
- Compatible with PHP `>=7.3`

---

