<?php

namespace FiloBlu\Refilo\Plugins\Api;

use Magento\Framework\Module\Manager;

/**
 * @class OrderExtensionAttributes
 * @package FiloBlu\Refilo\Plugins\Api
 */
class OrderRepositoryInterfacePlugin
{

    /**
     * @var Manager
     */
    private $moduleManager;


    /**
     * @param Manager $moduleManager
     */
    public function __construct(Manager $moduleManager)
    {
        $this->moduleManager = $moduleManager;
    }

    /**
     * @param $subject
     * @param $order
     * @return mixed
     */
    public function afterGet(
        $subject,
        $order
    ) {
        $extensionAttributes = $order->getExtensionAttributes();

        $isInStore = false;
        if ($this->moduleManager->isEnabled('Bcame_Viewide')) {
            $isInStore = (bool)$extensionAttributes->getIsViewideOrder();
        }

        $order->setIsInStore($isInStore);
        $extensionAttributes->setIsInStore((int)$isInStore);
        $order->setExtensionAttributes($extensionAttributes);

        return $order;
    }

    /**
     * @param $subject
     * @param $searchResult
     * @return mixed
     */
    public function afterGetList(
        $subject,
        $searchResult
    ) {
        foreach ($searchResult->getItems() as $order) {
            $this->afterGet($subject, $order);
        }

        return $searchResult;
    }
}
