<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Data\OrderMapping;

use FiloBlu\Refilo\Api\Data\OrderMappingInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * @class OrderMapping
 * @package FiloBlu\Refilo\Model\Data\OrderMapping
 */
class OrderMapping extends AbstractModel implements OrderMappingInterface
{
    /**
     * @return int
     */
    public function getId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
        return $this->getData(OrderMappingInterface::CUSTOMER_ID);
    }

    /**
     * @param int $customerId
     * @return $this|OrderMapping
     */
    public function setCustomerId($customerId)
    {
        $this->setData(OrderMappingInterface::CUSTOMER_ID, $customerId);
        return $this;
    }

    /**
     * @return int
     */
    public function getOrderId()
    {
        return $this->getData(OrderMappingInterface::ORDER_ID);
    }

    /**
     * @param int $orderId
     * @return $this|OrderMapping
     */
    public function setOrderId($orderId)
    {
        $this->setData(OrderMappingInterface::ORDER_ID, $orderId);
        return $this;
    }

    /**
     * @return int
     */
    public function getOrderStoreId()
    {
        return $this->getData(OrderMappingInterface::ORDER_STORE_ID);
    }

    /**
     * @param $storeId
     * @return $this|OrderMapping
     */
    public function setOrderStoreId($storeId)
    {
        $this->setData(OrderMappingInterface::ORDER_STORE_ID, $storeId);
        return $this;
    }
}
