<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Data\Remote;

use FiloBlu\Refilo\Remote\Connector\ConnectorPool;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class ConnectorOptions
 * @package FiloBlu\Refilo\Data\Remote
 */
class ConnectorOptions implements OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options;
    /**
     * @var ConnectorPool
     */
    private $connectorProvider;

    /**
     * ConnectorOptions constructor.
     * @param ConnectorPool $connectorProvider
     */
    public function __construct(ConnectorPool $connectorProvider)
    {
        $this->connectorProvider = $connectorProvider;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        if ($this->options !== null) {

            return $this->options;
        }
        $this->options = [];

        foreach ($this->connectorProvider->getAll() as $name => $connector) {
            $this->options[] = [
                'label' => __($name),
                'value' => $name
            ];
        }

        return $this->options;

    }
}
